<?xml version="1.0" encoding="UTF-8"?>
<!-- Examination Introduction Stylesheet
     Start a new examination
     Written by Keith Wood, 16 June, 2000 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <!-- The name of the script processing this page -->
  <xsl:param name="engine">webexam.dll</xsl:param>
  <!-- The user's id -->
  <xsl:param name="ses">123</xsl:param>

  <!-- The overall document -->
  <xsl:template match="/">
    <html>
    <head>
    <title><xsl:value-of select="exam/title"/></title>
    </head>
    <body>
    <xsl:apply-templates select="exam"/>
    <hr/>
    <p>Written by <a href="mailto:kbwood@iprimus.com.au">Keith Wood</a>.</p>
    </body>
    </html>
  </xsl:template>

  <!-- Show exam name, description, and instructions -->
  <xsl:template match="exam">
    <h1><xsl:value-of select="title"/></h1>
    <p><xsl:value-of select="description"/></p>
    <p>This test has <strong><xsl:value-of select="count(question)"/></strong>
      questions and a pass mark of
      <strong><xsl:value-of select="@pass_mark"/>%</strong>.</p>
    <p><xsl:value-of select="instructions"/></p>
    <!-- Link to start of exam -->
    <form method="post" action="{$engine}">
      <div align="center">
        <input type="hidden" name="ses" value="{$ses}"/>
        <input type="hidden" name="act" value="Goto"/>
        <input type="hidden" name="qno" value="1"/>
        <input type="submit" value="Start the exam"/>
      </div>
    </form>
  </xsl:template>
</xsl:stylesheet>
